package gov.va.med.mhv.rxrefill.data.repository;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.rxrefill.data.model.Request;

@Repository
public interface RequestRepository extends JpaRepository<Request, Long> {
		
	@Query("select r " +
			"from Request r " +
			"where  r.isInactive = 0 " +
			"and r.userId = :userId " +
			"and r.requestFunction in ('3', '4', '50') " + 
			"and r.status = 'successful' " +
			"and r.modifiedDate = ( " +
				"select MAX(r1.modifiedDate) " +
				"from Request r1 " +
				"where r1.isInactive = 0 " +
				"and r1.institution.institutionId = r.institution.institutionId " +
				"and r1.userId = :userId " +
				"and r1.requestFunction = r.requestFunction " +
				"and r1.status = 'successful')" + 
			"order by r.modifiedDate desc")
	public List<Request> getLatestSuccessfulExtractRequests(@Param("userId") Long userId);
	
	@Query("select r " +
			"from Request r " +
			"where  r.isInactive = 0 " +
			"and r.userId = :userId " +
			"and r.institutionId = :institutionId " +
			"and r.requestFunction in ('3', '4', '50') " + 
			"and r.status = 'successful' " +
			"and r.modifiedDate = ( " +
				"select MAX(r1.modifiedDate) " +
				"from Request r1 " +
				"where r1.isInactive = 0 " +
				"and r1.institution.institutionId = r.institution.institutionId " +
				"and r1.userId = :userId " +
				"and r1.requestFunction = r.requestFunction " +
				"and r1.status = 'successful')" + 
			"order by r.modifiedDate desc")
	public List<Request> getLatestSuccessfulExtractRequests(@Param("userId") Long userId, @Param("institutionId") Long institutionId);

	@Query("select r " +
			"from Request r " +
			"where r.isInactive = 0 " +
			"and r.userId = :userId " +
			"and r.modifiedDate = ( " +
				"select MAX(r1.modifiedDate) " +
				"from Request r1 " +
				"where r1.isInactive = 0 " +
				"and r1.institution.institutionId = r.institution.institutionId " +
				"and r1.userId = :userId)")
	public List<Request> getLatestRequestsByFacility(@Param("userId") Long userId);
	
	@Query("select r " +
			"from Request r " +
			"where r.isInactive = 0 " +
			"and r.institution.id = :institutionId " +
			"and r.userId = :userId")
	public List<Request> getRequestsForPatientAndInstitution(@Param("userId") Long userId, @Param("institutionId") Long institutionId);
	
	@Query("select r " +
			"from Request r " +
			"where r.isInactive = 0 " +
			"and r.userId = :userId")
	public List<Request> getRequestsForPatient(@Param("userId") Long userId);
	
	@Query("select r " +
			"from Request r " +
			"where r.isInactive = 0 " +
			"and r.userId = :userId " +
			"and r.requestFunction = :requestFunction")
	public List<Request> getRequestsForPatientByFunction(@Param("userId") Long userId, @Param("requestFunction") int requestFunction);
	
	@Query("select r " +
			"from Request r " +
			"where r.isInactive = 0 " +
			"and r.userId = :userId " +
			"and r.institution.institutionId = :institutionId " +
			"and r.requestFunction = :requestFunction " +
			"and r.createdDate >= :fromDate " +
			"and r.createdDate < :toDate " +
			"order by r.createdDate desc")
	public List<Request> getRequests(@Param("userId") Long userId, @Param("requestFunction") int requestFunction, 
			@Param("institutionId") Long institutionId, @Param("fromDate") Date fromDate, @Param("toDate") Date toDate);
	
	@Query("select count(ra) "
			+ "from Request r, RequestAttempt ra "
			+ "where r.isInactive = 0 "
			+ "and r.id = ra.requestId "
			+ "and r.userId = :userId "
			+ "and r.institutionId = :institutionId "
			+ "and r.requestFunction = :requestFunction "
			+ "and r.modifiedDate >= :fromDate "
			+ "and r.modifiedDate < :toDate "
			+ "and ra.status = 'successful' ")
	public Long countSuccessfulRequests(@Param("userId") Long userId, @Param("requestFunction") int requestFunction, 
			@Param("institutionId") Long institutionId, @Param("fromDate") Date fromDate, @Param("toDate") Date toDate);
	
	@Query("select count(ra) "
			+ "from Request r, RequestAttempt ra "
			+ "where r.isInactive = 0 "			
			+ "and r.id = ra.requestId "
			+ "and r.userId = :userId "
			+ "and r.institutionId = :institutionId "
			+ "and r.requestFunction = :requestFunction "
			+ "and r.modifiedDate >= :fromDate "
			+ "and r.modifiedDate < :toDate "
			+ "and ra.status = 'failed' ")
	public Long countFailedRequestAttempts(@Param("userId") Long userId, @Param("requestFunction") int requestFunction, 
			@Param("institutionId") Long institutionId, @Param("fromDate") Date fromDate, @Param("toDate") Date toDate);
	
	@Query("select count(ra) "
			+ "from Request r, RequestAttempt ra "
			+ "where r.isInactive = 0 "			
			+ "and r.id = ra.requestId "
			+ "and r.userId = :userId "
			+ "and r.institutionId = :institutionId "
			+ "and r.requestFunction = :requestFunction "
			+ "and r.modifiedDate >= :fromDate "
			+ "and r.modifiedDate < :toDate "
			+ "and ra.status = 'failed' ")
	public Long countFailedRequests(@Param("userId") Long userId, @Param("requestFunction") int requestFunction, 
			@Param("institutionId") Long institutionId, @Param("fromDate") Date fromDate, @Param("toDate") Date toDate);

}
